﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_UzupelnianieLukIII : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {
                correct = new List<string>();
                answers = new List<string>();
            }

            public int id { get; set; }
            public string text { get; set; }
            public List<string> correct { get; set; }
            public List<string> answers { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        public GExerciseData_UzupelnianieLukIII(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        {
            
        }

        public void Load()
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Section: OpenGap_SectionLoad(ContextParam.ExerciseOut); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Text: OpenGap_TextLoad(ContextParam.ExerciseOut); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_OpenGap: Questions_OpenGapLoad(ContextParam.ExerciseOut); break;
                }
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            if (ContextParam.ExerciseIn != null)
            {
                switch (ContextParam.ExerciseIn.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Section: OpenGap_SectionCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Text: OpenGap_TextCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_OpenGap: Questions_OpenGapCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                }

                SetExerciseOwlSave();
            }
        }

        private void OpenGap_SectionLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;
            XmlNode _xmlSections = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Sections);
            XmlNodeList _listXmlSection = _xmlSections.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);


            foreach (XmlNode _loopXmlQuestion in _listXmlSection)
            {
                _stubIndex++;

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.correct = new List<string>();

                StringBuilder _sbText = new StringBuilder();

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                    {
                        _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }

                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        _sbText.Append(Dictionary.OPEN_GAP);
                        _loopStub.correct.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }
                }

                _loopStub.text = _sbText.ToString();

                ExerciseData.Add(_loopStub);   
            }
        }

        private void OpenGap_TextLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            StringBuilder _sbText = new StringBuilder();
            ExerciseDataStub _loopStub = new ExerciseDataStub();
            _loopStub.id = 1;
            _loopStub.correct = new List<string>();


            XmlNode _xmlExercise_Text = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Exercise_Text);

            foreach (XmlNode _loopXml in _xmlExercise_Text.ChildNodes)
            {
                if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                {
                    _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                }

                if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                {
                    _sbText.Append(Dictionary.OPEN_GAP);
                    _loopStub.correct.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                }
            }

            _loopStub.text = _sbText.ToString();
            ExerciseData.Add(_loopStub);
        }

        private void Questions_OpenGapLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;
            XmlNode _xmlQuestions = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions);
            XmlNodeList _listXmlQuestion = _xmlQuestions.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Question);


            foreach (XmlNode _loopXmlQuestion in _listXmlQuestion)
            {
                _stubIndex++;

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.correct = new List<string>();

                StringBuilder _sbText = new StringBuilder();

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                    {
                        _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }

                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        _sbText.Append(Dictionary.OPEN_GAP);
                        _loopStub.correct.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }
                }

                _loopStub.text = _sbText.ToString();

                ExerciseData.Add(_loopStub);
            }
        }


        private void OpenGap_SectionCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            Exercise.TmpPoints = 0;

            int _stubIndex = 0;
            int _optionsCounter = 0;

            XmlNode _xmlSections = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Sections);
            XmlNodeList _listXmlSection = _xmlSections.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);


            foreach (XmlNode _loopXmlQuestion in _listXmlSection)
            {
                _stubIndex++;

                GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
                GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                _loopExerciseCheck.id = _stubIndex+1;
                _optionsCounter = 0;

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], BLP.BLELearning.Utility.ValueDictionary(_loopXml).Values))
                        {
                            Exercise.TmpPoints++;
                            _loopExerciseCheck.success_arr.Add(true);
                        }
                        else
                        {
                            _loopExerciseCheck.success_arr.Add(false);
                        }

                        _optionsCounter++;
                    }
                }

                ExerciseCheck.Add(_loopExerciseCheck);
                _stubIndex++;
            }
        }

        private void OpenGap_TextCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            Exercise.TmpPoints = 0;

            int _stubIndex = 0;
            int _optionsCounter = 0;


            XmlNode _xmlExercise_Text = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Exercise_Text);

            GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
            GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
            _loopExerciseCheck.id = _stubIndex++;
            foreach (XmlNode _loopXml in _xmlExercise_Text.ChildNodes)
            {
                if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                {
                    if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], BLP.BLELearning.Utility.ValueDictionary(_loopXml).Values))
                    {
                        Exercise.TmpPoints++;
                        _loopExerciseCheck.success_arr.Add(true);
                    }
                    else
                    {
                        _loopExerciseCheck.success_arr.Add(false);
                    }

                    _optionsCounter++;
                }
            }

            ExerciseCheck.Add(_loopExerciseCheck);
        }

        private void Questions_OpenGapCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            Exercise.TmpPoints = 0;

            int _stubIndex = 0;
            int _optionsCounter = 0;

            XmlNode _xmlQuestions = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions);
            XmlNodeList _listXmlQuestion = _xmlQuestions.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Question);


            foreach (XmlNode _loopXmlQuestion in _listXmlQuestion)
            {
                GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
                GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                _loopExerciseCheck.id = _stubIndex+1;
                _optionsCounter = 0;

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], BLP.BLELearning.Utility.ValueDictionary(_loopXml).Values))
                        {
                            Exercise.TmpPoints++;
                            _loopExerciseCheck.success_arr.Add(true);
                        }
                        else
                        {
                            _loopExerciseCheck.success_arr.Add(false);
                        }

                        _optionsCounter++;
                    }
                }

                ExerciseCheck.Add(_loopExerciseCheck);
                _stubIndex++;
            }
        }
    }
}
